<?php
/*
Copyright (C) 2004  Brian J. Mullen

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("header.inc.php");

if($type_login != 2) {
  echo("You do not have permission to set the parameters of Collections Keeper");
  exit();
}
echo("<H2>Change Collections Keepers settings</H2>");

if(isset($_POST['submit'])) {
	$fp = fopen("collParams.inc.php", "w+b");
	if (!$fp) {
		echo ("<BR>Can't create new settings file.  Most likey don't have write permission.  If the file collParams.inc.php is set to read only(as recommended on the install) give write permissions, change settings and then set the permissions back to read only.");
		exit();
	}
	$str_settings = "<?php";
	$str_settings .= "\n/*";
	$str_settings .= "\nCopyright (C) 2004  Brian J. Mullen";
	$str_settings .= "\n";
	$str_settings .= "\nThis program is free software; you can redistribute it and/or";
	$str_settings .= "\nmodify it under the terms of the GNU General Public License";
	$str_settings .= "\nas published by the Free Software Foundation; either version 2";
	$str_settings .= "\nof the License, or (at your option) any later version.";
	$str_settings .= "\n";
	$str_settings .= "\nThis program is distributed in the hope that it will be useful,";
	$str_settings .= "\nbut WITHOUT ANY WARRANTY; without even the implied warranty of";
	$str_settings .= "\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the";
	$str_settings .= "\nGNU General Public License for more details.";
	$str_settings .= "\n";
	$str_settings .= "\nYou should have received a copy of the GNU General Public License";
	$str_settings .= "\nalong with this program; if not, write to the Free Software";
	$str_settings .= "\nFoundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.";
	$str_settings .= "\n*/";
	$str_settings .= "\n//database info";
	$str_settings .= "\n\$database_name = \"" . $_POST['database_name'] . "\";";
	$str_settings .= "\n\$db_location = \"" . $_POST['db_location'] . "\";";
	$str_settings .= "\n\$db_user_name = \"" . $_POST['db_user_name'] . "\";";
	$str_settings .= "\n\$db_password = \"" . $_POST['db_password'] . "\";";
	$str_settings .= "\n//user settings";
	$str_settings .= "\n\$user_timeout = " . $_POST['user_timeout'] . ";";
	$str_settings .= "\n//admin settings";
	$str_settings .= "\n\$admin_timeout = " . $_POST['admin_timeout'] . ";";
	$str_settings .= "\n//file settings";
	$str_settings .= "\n\$allow_files = ";
	if($_POST['allow_files']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "\n\$max_file_size = " . $_POST['max_file_size'] . ";";
	$file_extensions = explode(",", $_POST['file_extensions']);
	for($i = 0; $i < count($file_extensions); $i++) {
		//handle ending extra
		if($file_extensions[$i] == "") continue;
		$str_settings .= "\n\$file_extensions[$i] = \"" . trim($file_extensions[$i]) . "\";";
	}
	$str_settings .= "\n//session settings";
	$str_settings .= "\n\$use_sessions = ";
	if($_POST['use_sessions']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "\n//website settings";
	$str_settings .= "\n\$allow_anon_reg = ";
	if($_POST['allow_anon_reg']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "  //Allow anonymous registration to create privileged users";
	$str_settings .= "\n\$allow_anon_view = ";
	if($_POST['allow_anon_view']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "  //Allow anonymous users to view tables";
	$str_settings .= "\n\$force_own_view = ";
	if($_POST['force_own_view']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "  //Forces users to only be able to see their own collections, overides \$allow_anon_view";
	$str_settings .= "\n\$allow_priv_edit_sub = ";
	if($_POST['allow_priv_edit_sub']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "  //Allow privileged users to add,edit and delete from sub-tables";
	$str_settings .= "\n\$enforce_exp = ";
	if($_POST['enforce_exp']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "  //enforce expiration timeouts on non-privileged users";
	$str_settings .= "\n\$default_exp = " . $_POST['default_exp'] . ";";
	$str_settings .= "//default number of days before a non-privileged users login will expire";
	$str_settings .= "\n\$use_gd = ";
	if($_POST['use_gd']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "  //use the gd library for manipulating images, causes the database";
	$str_settings .= "\n              //to use thumbnails for images rather then just showing links";
	$str_settings .= "\n\$max_thumb_size = " . $_POST['max_thumb_size'] . ";";
	$str_settings .= "\n\$use_already_entered = ";
	if($_POST['use_already_entered']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "//whether or not to present drop downs for already entered.";
	$str_settings .= "\n\$use_batch_already_entered = ";
	if($_POST['use_batch_already_entered']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "//whether or not to present drop downs for already entered when doing batch entries.";
	$str_settings .= "\n\$use_all_users_entered = ";
	if($_POST['use_all_users_entered']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "//whether to use all users or just active user for already entered";
	$str_settings .= "\n\$allow_priv_sql = ";
	if($_POST['allow_priv_sql']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "//allows privileged users to run bookmarked sql statements";
	$str_settings .= "\n\$allow_anon_sql = ";
	if($_POST['allow_anon_sql']) $str_settings .= "1;";
	else $str_settings .= "0;";
	$str_settings .= "//allows anonymous users to run bookmarked sql statements";
	$str_settings .= "\n?>";
	fwrite ($fp, $str_settings);
	fclose($fp);
	echo("<BR>Collection Keeper setting have been changed");
}
else {
	echo("\n<FORM ACTION=" . $_SERVER['PHP_SELF'] . " METHOD=POST>");
	echo("\n<table border=1>");
	//database settings
	echo("\n<TR><TH COLSPAN=2><B>Database settings</B></TH><TH>Notes</TH></TR>");
	echo("\n<TR><TD>Name</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=database_name Value=$database_name></TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD>Location</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=db_location Value=$db_location></TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD>User Name</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=db_user_name Value=$db_user_name></TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD>User Password</TD>");
	echo("\n<TD><INPUT TYPE=password NAME=db_password Value=$db_password></TD>");
	echo("\n<TD>&nbsp;</TD>");
	echo("</TR>");
	//user settings
	echo("\n<TR><TH COLSPAN=2>User Settings</TH></TR>");
	echo("\n<TR><TD>User Login Timeout</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=user_timeout Value=$user_timeout></TD>");
	echo("\n<TD>Timeout is in seconds, use 0 for never timeout</TD>");
	echo("\n</TR>");
	//admin settings
	echo("\n<TR><TH COLSPAN=2>Admin Settings</TH></TR>");
	echo("\n<TR><TD>Admin Login Timeout</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=admin_timeout Value=$admin_timeout></TD>");
	echo("\n<TD>Timeout is in seconds, use 0 for never timeout</TD>");
	echo("\n</TR>");
	//file settings
	echo("\n<TR><TH COLSPAN=2>File Settings</TH></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=allow_files ");
	if($allow_files) echo("checked");
	echo(">Allow files in the database</TD>");
	echo("<TD>Depending on how large you set the max file size files can eat up major resources and major bandwidth.  If you disable this then users cannot upload files and cannot view files.</TD>");
	echo("</TR>");
	echo("\n<TR><TD>Max file size in bytes</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=max_file_size Value=$max_file_size></TD>");
	echo("\n<TD>The default sizes in the PHP.ini for a Post is 8MB and for a file is 2MB.  The default timeout for a PHP script is 30 secs.  The largest filesize that can currently be handled is 2GB.  If you want to use files larger 2MB ensure you change your PHP.ini settings.</TD>");
	echo("\n</TR>");
	$str_ext = "";
	for($i = 0; $i < count($file_extensions); $i++) $str_ext .= $file_extensions[$i] . ",";
	echo("\n<TR><TD>Allowable file extensions<BR>comma seperated</TD>");
	echo("\n<TD><TEXTAREA NAME=file_extensions COLS=20>$str_ext</TEXTAREA></TD>");
	echo("\n<TD>It is highly recommended that you never allow php, pl, asp, vbs or any other file extension that may result in an execution of the script when it is uploaded.  As some files may also contain macros that will load when users load the file you may also not want to allow those as well.  Examples are doc for word documents or xls for excel spreadsheets that may run a macro when loaded.</TD>");
	echo("\n</TR>");
	//session settings
	echo("\n<TR><TH COLSPAN=2>Session settings</TH></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=use_sessions ");
	if($use_sessions) echo("checked");
	echo(">Use PHP sessions for tracking login</TD>");
	echo("\n<TD>It is highly recommended that you use PHP sessions for user logins.  It is, in general, more secure.  If this is enabled then session variables are used for user login.  If it is not enabled then only the ip of the user is used to track login.  If you find that you or your users are having problems with sessions then you may disable this but it is not recommended.</TD>");
	echo("</TR>");
	//website settings
	echo("\n<TR><TH COLSPAN=2>General Website settings</TH></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=allow_anon_reg ");
	if($allow_anon_reg) echo("checked");
	echo(">Allow anonymous registration</TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=allow_anon_view ");
	if($allow_anon_view) echo("checked ");
	echo(">Allow anonymous users to view primary tables</TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=force_own_view ");
	if($force_own_view) echo("checked ");
	echo(">Force users to only see their own collections.</TD>");
	echo("<TD>This will overide \"Allow anonymous view of tables\".  Doesn't apply to administrators.</TD></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=allow_priv_edit_sub ");
	if($allow_priv_edit_sub) echo("checked ");
	echo(">Allow privileged users to add/edit/delete from sub-tables</TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=enforce_exp ");
	if($enforce_exp) echo("checked");
	echo(">Enforce expiration timeout on non-priviledged users</TD>");
	echo("\n<TD>With this disabled non-priviledged users will be treated as priviledged users even when their acount has expired</TD>");
	echo("\n</TR>");
	echo("\n<TR><TD>Default number of days a non-privileged user account will remain active</TD>");
	echo("\n<TD><INPUT TYPE=text NAME=default_exp VALUE=$default_exp></TD>");
	echo("<TD>&nbsp;</TD></TR>");
	echo("\n<TR><TD COLSPAN=2>");
	echo("<INPUT TYPE=checkbox name=use_gd ");
	if($use_gd) echo("checked");
	//make sure that we only give them the option to enable the GD lib if it is available
	if(gd_version() == 0) echo(" disabled");
	echo(">Use the GD library to manipulate images</TD>");
	echo("<TD>Causes collection keeper to create thumbnails for jpeg or png images and show them instead of a link to the file.  If this is disabled then you have not enabled your GD lib.  See www.php.net about enabling it");
	echo("\n</TR>");
	echo("<TR><TD>Max width/height of thumbnails</TD>");
	echo("<TD><INPUT TYPE=text NAME=max_thumb_size VALUE=$max_thumb_size></TD>");
	echo("<TD>With GD Library enabled this sets the maximum width/height that a thumbnail will be.  This is ignored if GD is not enabled.</TD></TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=use_already_entered ");
	if($use_already_entered) echo("checked ");
	echo(">Use the \"Already Entered\" drop downs</TD>");
	echo("\n<TD>With then enabled when creating a collection entry the user will be presented with drop downs populated from previous entries.  This can create a heavy load on the server and database from the many queries it causes.  If a value is selected from an \"Already Entered\" drop down it will overide user input into the text box unless the blank is chosen from the drop down.</TD>");
	echo("\n</TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=use_batch_already_entered ");
	if($use_batch_already_entered) echo("checked ");
	echo(">Use the \"Already Entered\" drop downs for batch entries</TD>");
	echo("\n<TD>When enabled this will present the \"Already Entered\" drop downs when doing batch entries.  Turning this off will decrease server load when doing batch entries and decrease load time for the batch entries page.</TD>");
	echo("\n</TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=use_all_users_entered ");
	if($use_all_users_entered) echo("checked ");
	echo(">When using \"Already Entered\" populated from all users</TD>");
	echo("\n<TD>When enabled \"Already Entered\" drop downs will populate from all users.  When disabled it will populate from just the active user.</TD>");
	echo("\n</TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=allow_priv_sql ");
	if($allow_priv_sql) echo("checked ");
	echo(">Allows privileged users to run bookmarked sql statments.</TD>");
	echo("\n<TD>Does not allow privileged users to create sql bookmarks, just run the ones that the admin has created for privileged users.</TD>");
	echo("\n</TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=checkbox name=allow_anon_sql ");
	if($allow_anon_sql) echo("checked ");
	echo(">Allows all users to run bookmarked sql statments.</TD>");
	echo("\n<TD>Does not allow anonymous users to create sql bookmarks, just run the ones that the admin has created for all users.</TD>");
	echo("\n</TR>");
	echo("\n<TR><TD COLSPAN=2><INPUT TYPE=SUBMIT NAME=submit VALUE=SUBMIT></TD></TR>");
}
include("footer.inc.php");
?>