import java.sql.*;
import java.util.*;

/**
 *  Predicts movie ratings based only on the word frequencies between the movie and the user.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class PredictFromWords {

	/**
	 *  Predicts movie ratings based on word frequencies.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		int actualRating;
		int predictedRating;
		double posVal;
		double negVal;
		String query;
		String ratingID;
		String userID;
		String movieID;
		String pos_words;
		String neg_words;
		String movie_words;
		User pos_user;
		User neg_user;
		User movie;
		Vector users;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		// clear temporary flags
		query = "update rating set training='' where training='t'";
		Query.executeUpdate( query );

		while ( true ) {
			// continually loop through ratings until all have been processed
			query = "select * from rating where training='' limit 1000";
			ResultSet ratingResult = Query.executeQuery( query );
			if ( Query.getNumResults( ratingResult ) <= 0 ) {
				break;
			}

			try {
				while ( ratingResult.next() ) {
					ratingID = ratingResult.getString( "id" );
					userID = ratingResult.getString( "user_id" );
					movieID = ratingResult.getString( "movie_id" );
					actualRating = ( new Integer( ratingResult.getString( "rating" ) ) ).intValue();

					// get words frequencies for that user
					query = "select pos_word_freq,neg_word_freq from user where id=" + userID;
					ResultSet userResult = Query.executeQuery( query );
					if ( Query.getNumResults( userResult ) > 0 ) {
						userResult.first();
						pos_words = userResult.getString( "pos_word_freq" );
						neg_words = userResult.getString( "neg_word_freq" );

						// get word frequencies for movie
						query = "select word_freq from movie where id=" + movieID;
						ResultSet wordsResult = Query.executeQuery( query );
						if ( Query.getNumResults( wordsResult ) > 0 ) {
							wordsResult.first();
							movie_words = wordsResult.getString( "word_freq" );

							// create 'users' from each of the 3 sets of word frequencies, in order to compare them
							System.out.println( "\nUser: " + userID );
							pos_user = new User( userID, pos_words );
							neg_user = new User( userID, neg_words );
							movie = new User( movieID, movie_words );

							// check if user's positive words or negative words correlate more to movie words
							posVal = pos_user.compareTo( movie );
							negVal = neg_user.compareTo( movie );

							System.out.println( "pos: " + posVal );
							System.out.println( "neg: " + negVal );

							// make the prediction
							if ( posVal == 0 && negVal == 0 ) {
								predictedRating = 3;
							}
							else if ( posVal >= negVal ) {
								predictedRating = 4;
							}
							else {
								predictedRating = 2;
							}
						}
						// if no movie words, just predict 3 (a good middle guess)
						else {
							predictedRating = 3;
						}
						wordsResult.close();
					}
					// if no user words, just predict 3 (a good middle guess)
					else {
						predictedRating = 3;
					}
					userResult.close();

					// update rating table with prediction
					query = "update rating set rating2=" + predictedRating + " where id=" + ratingID;
					Query.executeUpdate( query );

					// set temporary flag so we know this one is done
					query = "update rating set training='t' where id=" + ratingID;
					Query.executeUpdate( query );

					// display result of prediction
					System.out.println( actualRating + " -> " + predictedRating );
				}
				ratingResult.close();
			}
			catch (SQLException e) {
				System.err.println("Error predicting ratings from user words...");
				e.printStackTrace();
				System.exit(0);
			}
		}

	}
}

