import java.io.*;
import java.sql.*;
import java.util.*;

/**
 *  Parses the IMDB movie data file, and extracts the years for each movie
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class ParseIMDBYear {

	final static String filename = "data/movies.list";

	/**
	 *  Parses the movie data file, get the year for each movie.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String line = "";
		String movieTitle;
		String releaseYear;
		BufferedReader buffer;
		StringTokenizer tok;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		try {
			// read through the data file
			buffer = new BufferedReader( new FileReader( filename ) );
			line = buffer.readLine();
			while ( line != null ) {
				// tokenize each line - fields are tab-delimited
				tok = new StringTokenizer( line, "\t" );
				movieTitle = tok.nextToken();
				releaseYear = tok.nextToken();
				releaseYear = releaseYear.substring( 0, 4 );

				movieTitle = Query.cleanMovieTitle( movieTitle );
				// even more error checking!!!
				if ( movieTitle.trim().length() == 0 ) {
					line = buffer.readLine();
					continue;
				}
				System.out.println( movieTitle + " -> " + releaseYear );

				// fix truncated titles - this field intially had a length of only 50 chars (BIG mistake!!!)
				if ( movieTitle.length() > 45 ) {
					String miniTitle = movieTitle.substring( 0, 45 );
					query = "select id from movie where title like '" + miniTitle + "%'";
					ResultSet titleResult = Query.executeQuery( query );
					if ( Query.getNumResults( titleResult ) > 0 ) {
						titleResult.first();
						String movieID = titleResult.getString( "id" );
						query = "update movie set title='" + movieTitle + "' where id=" + movieID;
						Query.executeUpdate( query );
					}
				}

				// check if movie in database
				query = "select id from movie where title = '" + movieTitle + "'";
				ResultSet titleResult = Query.executeQuery( query );
				if ( Query.getNumResults( titleResult ) > 0 ) {
					titleResult.first();
					String movieID = titleResult.getString( "id" );

					// update year for movie
					query = "update movie set year='" + releaseYear + "' where id=" + movieID;
					Query.executeUpdate( query );
				}
				else {
					System.out.println( "\t*** Movie '" + movieTitle + "' not found in database" );
				}
				titleResult.close();
				line = buffer.readLine();
			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error executing SQL statement while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( FileNotFoundException e ) {
			System.err.println( "Could not find IMDB movie data file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading data file while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

