import java.io.*;
import java.sql.*;

/**
 *  Parses the IMDB plot data file and loads it into the database.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class ParseIMDBPlot {

	final static String filename = "data/plot.list";

	/**
	 *  The main program for the ParseIMDBPlot class
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String line = "";
		String movieTitle;
		String moviePlot;
		BufferedReader buffer;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		try {
			// read through data file
			buffer = new BufferedReader( new FileReader( filename ) );
			line = buffer.readLine().trim();
			while ( line != null ) {
				// ------ occurs before new movie plot, keep reading until we get there
				while ( line.indexOf( "-----" ) < 0 ) {
					line = buffer.readLine().trim();
					if ( line == null ) {
						return;
					}
				}

				line = buffer.readLine().trim();

				// first 4 chars of each line are junk
				movieTitle = line.substring( 4, line.length() );
				movieTitle = Query.cleanMovieTitle( movieTitle );
				// some more handy error checking!
				if ( movieTitle.length() == 0 ) {
					line = buffer.readLine().trim();
					continue;
				}

				moviePlot = "";
				line = buffer.readLine().trim();
				// loop through lines until it starts with 'BY:' - then we know we're done
				while ( line.indexOf( "BY:" ) < 0 ) {
					if ( line.length() == 0 ) {
						line = buffer.readLine().trim();
						continue;
					}
					// first 4 chars of each line are junk
					line = line.substring( 4, line.length() );
					moviePlot += line + " ";
					line = buffer.readLine().trim();
				}
				moviePlot = Query.cleanPlot( moviePlot );

				// find movie in database
				query = "select id from movie where title='" + movieTitle + "'";
				ResultSet titleResult = Query.executeQuery( query );
				if ( Query.getNumResults( titleResult ) > 0 ) {
					titleResult.first();
					String movieID = titleResult.getString( "id" );
					// update database with plot of movie
					query = "update movie set plot='" + moviePlot + "' where id=" + movieID;
					Query.executeUpdate( query );
					System.out.println( movieTitle );
					System.out.println( moviePlot );
				}
				else {
					System.out.println( "*** Movie '" + movieTitle + "' not found in database" );
				}
				titleResult.close();

				System.out.println( "" );
				line = buffer.readLine().trim();
			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error executing SQL statement while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( FileNotFoundException e ) {
			System.err.println( "Could not find IMDB plot data file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading data file while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

