import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.regex.*;

/**
 *  Parses the IMDB directors data file and loads it into the database.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class ParseIMDBDirector {

	final static String filename = "data/directors.list";

	/**
	 *  Parses the directors data file.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String line = "";
		BufferedReader buffer;
		StringTokenizer tok;
		String directorName;
		String movieTitle;
		String directorID;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		try {
			// read through the data file
			buffer = new BufferedReader( new FileReader( filename ) );
			line = buffer.readLine();
			while ( line != null ) {
				// tokenize each line - fields are tab-delimited
				tok = new StringTokenizer( line, "\t" );
				// loop through any blank lines
				if ( !tok.hasMoreTokens() ) {
					line = buffer.readLine();
					continue;
				}
				directorName = tok.nextToken();
				// error checking - this shouldn't happen, but just being careful!
				if ( !tok.hasMoreTokens() ) {
					line = buffer.readLine();
					continue;
				}

				movieTitle = tok.nextToken();

				directorName = Query.cleanActorName( directorName );
				System.out.println( directorName );

				// check if director already in database, don't want to add him twice!
				query = "select id from director where name='" + directorName + "'";
				ResultSet directorResult = Query.executeQuery( query );
				if ( Query.getNumResults( directorResult ) > 0 ) {
					directorResult.first();
					directorID = directorResult.getString( "id" );
				}
				// if not in database, add it!
				else {
					query = "insert into director (name) values ('" + directorName + "')";
					Query.executeUpdate( query );
					query = "select id from director where name='" + directorName + "'";
					directorResult = Query.executeQuery( query );

					// some more error checking, call me crazy!!
					if ( Query.getNumResults( directorResult ) <= 0 ) {
						while ( line.trim().length() != 0 ) {
							line = buffer.readLine();
						}
						continue;
					}
					directorResult.first();
					directorID = directorResult.getString( "id" );
				}
				directorResult.close();

				// get all movies they have directed
				while ( movieTitle.trim().length() != 0 ) {
					movieTitle = Query.cleanMovieTitle( movieTitle );
					if ( movieTitle.length() == 0 ) {
						movieTitle = buffer.readLine();
						continue;
					}

					// get movie id
					query = "select id from movie where title='" + movieTitle + "'";
					ResultSet movieResult = Query.executeQuery( query );
					if ( Query.getNumResults( movieResult ) > 0 ) {
						movieResult.next();
						String movieID = movieResult.getString( "id" );
						query = "update movie set director_id=" + directorID + " where id=" + movieID;
						Query.executeUpdate( query );
						System.out.println( "\t" + movieTitle );
					}
					else {
						System.out.println( "\t*** Movie '" + movieTitle + "' not found in database." );
					}
					movieResult.close();
					movieTitle = buffer.readLine();
				}
				line = buffer.readLine();
			}
		}
		catch ( SQLException e ) {
			System.err.println( "Error executing SQL statement while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( FileNotFoundException e ) {
			System.err.println( "Could not find IMDB director data file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading data file while parsing IMDB directors..." );
			e.printStackTrace();
			System.exit( 0 );
		}
	}
}

