import java.io.*;
import java.lang.*;
import java.math.*;
import java.sql.*;
import java.util.*;

/**
 *  Gets the list of words from each movie the user has rated.  These words are
 *  the actors in the movie, director, and plot description.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class GetUserWords {

	// hash tables to store words and frequencies
	private Hashtable stopList, globalList;

	/** Initializes the hashtables, connects to DB */
	public GetUserWords() {
		stopList = new Hashtable();
		globalList = new Hashtable();

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}
	}

	/**  Gets the words for all the movies each user has rated. */
	public void getWords() {
		String query;
		String userID;
		String movieID;
		String posWords;
		String negWords;
		int rating;

		while ( true ) {
			// continually loop through users until all have been processed.
			query = "select * from user where pos_words='' limit 1000";
			ResultSet userResult = Query.executeQuery( query );
			if ( Query.getNumResults( userResult ) == 0 ) {
				return;
			}

			try {
				while ( userResult.next() ) {
					userID = userResult.getString( "id" );
					// get all movies user has rated
					query = "select distinct movie_id, rating from rating where training='x' and user_id=" + userID;
					ResultSet movieResult = Query.executeQuery( query );
					posWords = "";
					negWords = "";

					// delete the user if they don't have any ratings
					if ( Query.getNumResults( movieResult ) == 0 ) {
						query = "delete from user where id=" + userID;
						Query.executeUpdate( query );
						query = "delete from rating where user_id=" + userID;
						Query.executeUpdate( query );
						System.out.println( "deleting " + userID );
						continue;
					}

					// get words from movies user has rated
					while ( movieResult.next() ) {
						movieID = movieResult.getString( "movie_id" );
						rating = ( new Integer( movieResult.getString( "rating" ) ) ).intValue();
						query = "select words from movie where id=" + movieID;
						ResultSet wordsResult = Query.executeQuery( query );
						if ( Query.getNumResults( wordsResult ) == 0 ) {
							continue;
						}
						wordsResult.first();
						if ( rating >= 3 ) {
							posWords += "(" + rating + ") " + wordsResult.getString( "words" ) + " ";
						}
						else {
							negWords += "(" + rating + ") " + wordsResult.getString( "words" ) + " ";
						}
					}
					movieResult.close();

					// update user table with list of positive words
					if ( posWords.trim().length() > 0 ) {
						query = "update user set pos_words='" + posWords.trim() + "' where id=" + userID;
					}
					else {
						query = "update user set pos_words='x' where id=" + userID;
					}
					Query.executeUpdate( query );

					// update user table with list of negative words
					if ( negWords.trim().length() > 0 ) {
						query = "update user set neg_words='" + negWords.trim() + "' where id=" + userID;
					}
					else {
						query = "update user set neg_words='x' where id=" + userID;
					}
					Query.executeUpdate( query );

					System.out.println( userID );
				}
				userResult.close();
			}
			catch ( SQLException e ) {
				System.out.println( "Error getting words..." );
				e.printStackTrace();
				System.exit( 0 );
			}
		}
	}

	/**
	 *  Reads the stop list into a hash table - these are common words that should be ignored since
	 *   they do not provide much contextual information.
	 */
	public void readStopList() {
		String filename = "stoplist.txt";
		String word;
		BufferedReader input;

		try {
			// open stop list file for reading
			input = new BufferedReader( new FileReader( filename ) );
			word = input.readLine();

			// add words to stoplist hashtable
			while ( word != null ) {
				stopList.put( word, word );
				word = input.readLine();
			}
			input.close();
		}
		catch ( FileNotFoundException e ) {
			System.out.println( "Could not find stoplist file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
		catch ( IOException e ) {
			System.err.println( "Error reading stoplist file: " + filename );
			e.printStackTrace();
			System.exit( 0 );
		}
	}

	/**
	 *  Gets the positive and negative words for each user.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		GetUserWords words = new GetUserWords();
		words.readStopList();
		System.out.println( "getting words for each user... \n" );
		words.getWords();
	}
}

