import java.sql.*;
import java.util.*;

/**
 *  Gets all the words related to a movie: genre, actors, director, plot description
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class GetMovieWords {

	/**
	 *  Gets the words for each movie.
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		String query = "";
		String words;

		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		// get all movies
		query = "SELECT id,title FROM movie WHERE words=''";
		ResultSet titleResult = Query.executeQuery( query );
		int num = Query.getNumResults( titleResult );

		try {
			while ( titleResult.next() ) {
				words = "";

				String movieID = titleResult.getObject( "id" ).toString();
				String movieTitle = titleResult.getObject( "title" ).toString();
				System.out.println( movieTitle + " : " + num );

				// get all actors in movie
				query = "SELECT actor.name FROM actor,movie_actor WHERE movie_actor.movie_id=" + movieID;
				query += " AND actor.id=movie_actor.actor_id";
				ResultSet actorResult = Query.executeQuery( query );

				while ( actorResult.next() ) {
					String actorName = actorResult.getObject( "actor.name" ).toString();
					words += Query.cleanActorName( actorName ) + " ";

				}
				actorResult.close();

				// get movie director
				query = "SELECT director.name FROM director,movie WHERE movie.id=" + movieID;
				query += " AND director.id=movie.director_id";
				ResultSet directorResult = Query.executeQuery( query );

				while ( directorResult.next() ) {
					String directorName = directorResult.getObject( "director.name" ).toString();
					words += Query.cleanActorName( directorName ) + " ";
				}
				directorResult.close();

				// get all genres of a movie
				query = "SELECT genre FROM genre,movie_genre WHERE movie_genre.movie_id=" + movieID;
				query += " AND genre.id=movie_genre.genre_id";
				ResultSet genreResult = Query.executeQuery( query );

				while ( genreResult.next() ) {
					String genre = genreResult.getObject( "genre" ).toString();
					words += genre + " ";
				}
				genreResult.close();

				// get plot of movie
				query = "SELECT plot FROM movie WHERE id=" + movieID;
				ResultSet plotResult = Query.executeQuery( query );

				while ( plotResult.next() ) {
					String plot = plotResult.getString( "plot" );
					if ( plot == null ) {
						continue;
					}
					words += Query.cleanPlot( plot ) + " ";
				}
				plotResult.close();

				// set words to lowercase
				words = words.trim().toLowerCase();

				// update movie table with words
				query = "UPDATE movie SET words='" + words + "' WHERE id=" + movieID;
				Query.executeUpdate( query );
				System.out.println( query + "\n" );

				num--;
			}
			titleResult.close();
		}
		catch (SQLException e) {
			System.err.println( "Error getting movie words..." );
			e.printStackTrace();
			System.exit(0);
		}
	}
}

