import java.sql.*;

/**
 *  Extracts movies from the EachMovie data set from the complete IMDB data set.
 *
 * @author     Brandon Douthit-Wood
 * @created    March 31, 2004
 */
public class GetEachMovieSet {

	/**
	 *  Gets the EachMovie data set
	 *
	 * @param  args  The command line arguments
	 */
	public static void main( String[] args ) {
		if ( !Query.connectToDB() ) {
			System.exit( 0 );
		}

		String query = "";

		// delete old values from movie table - just to make sure we aren't getting duplicate keys.
		query = "delete from movie";
		Query.executeQuery( query );

		// get distinct movies from the ratings - these will only be from EachMovie set, since
		// those are the only ones I have ratings for
		query = "select distinct movie_id from rating";
		ResultSet movieResult = Query.executeQuery( query );

		try {
			while ( movieResult.next() ) {
				String id = movieResult.getString( "movie_id" );
				System.out.println( id );

				// insert new record into movie table
				query = "insert into movie (id,title,plot,year,words,director_id)";
				query += " select id,title,plot,year,words,director_id from movie_complete where id=" + id;
				Query.executeUpdate( query );
			}
			movieResult.close();
		}
		catch (SQLException e) {
			System.err.println( "Error getting the EachMovie data set..." );
			e.printStackTrace();
			System.exit(0);
		}
	}
}

