import java.util.Random;
/**
 * Description of the Class 
 * The purpose of this class is to provide a random number generator for the Plant-Moose-Predator System Simulation
 *
 *@author    Anastasia Mironova
 *@created   February 22, 2003
 */
public class RandomNumberGenerator extends Random{
	/**
	 * Constructs a random number between two given values, including the boundaries.
	 */
	 public RandomNumberGenerator(){
		 super();
	 }
	 /**
	 * Constructs a random integer between two given values, including the boundaries.
	 */
	
	 public int getIntBetween(int lowerBound, int upperBound){
		 return (lowerBound + this.nextInt(upperBound - lowerBound + 1));
	 }
	 /**
	 * Constructs a random double between two given values, including the boundaries.
	 */
	
	 public double getDoubleBetween(double lowerBound, double upperBound){
		 return (lowerBound + this.nextDouble()*(upperBound - lowerBound));
	 }
}
