import java.lang.Thread;
import java.util.*;

/**
 * Description of the Class
 *
 * The purpose of this class is to describe a plant object and its associated characteristics within the
 * Plant-Moose-Predator System Simulation
 *
 *@author    Anastasia Mironova
 *@created   February 15, 2003
 */
public class Plant{
	
	/** Associated parameters of the plant
	*/
	private String id = "";
	private String species = "";
	
	private Location coordinates = null;
	
	private int numberIfBites;
	private double massOfBite;
	private int singleBiteQuality;
	private double size;
	private double growthRate;
	
	 /** Default constructor
	 Generates a default plant with a randomly generated id
	 */
	 public Plant(){
		 id = "Plant" + (new RandomNumberGenerator()).getIntBetween(1, 5);
	 }
	 
	 /*
	 Creates a new plant given a string id
	 */
	 public Plant(String idIn) {
	 	id = idIn;
	 }
	
	//return the id of a plant
	public String getId(){
		return id;
	}
}
