import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.Thread;
import java.util.*;
import javax.swing.border.*;

import java.util.Vector;


/**
 * Description of the class
 *
 * The purpose of this class is to enable the user to edit and remove existing components in the scene
 *
 * This component can be activated from the menu bar of the main application frame
 *
 * The basic implementation idea was adopted from the work I did on CSVE in summer of 2003, it is intended to be modified to
 * be able to adapt it to the PMPSim application's needs
 *
 * @created February 3, 2004
 * @author  Anastasia Mironova
 */
public class PMPSimAgentsFrame extends JFrame {
	// General variables
	private static JPanel mainPanel;
	private static JList crossSectionlist;
	private static JList isosurfacelist;
	private static JList computationalPlaneList;
	// End of variables declaration

   	public PMPSimAgentsFrame() {
		super("Agents Currently in the Scence");
		
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		
		setLocation(screen.width / 2, (screen.height - 65) / 2);
		
		//handle window closing event
		addWindowListener(new WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				buttonCancelActionPerformed();
			}
		});
		
		Vector plants = new Vector();
		Vector moose = new Vector();
		Vector predators = new Vector();
		for (int i = 1; i<=50; i++){
			plants.addElement("Plant" + "0" + i);
			moose.addElement("Moose" + "00" + i);
			predators.addElement("Predator" + i);
		}
		
		
		JPanel containerPanel = new JPanel();
		containerPanel.setLayout(new BorderLayout());
		
		mainPanel = new JPanel();
		
		JPanel choiceIsosurfacePanel = new JPanel();
		JLabel choiceIsoSurfaceLabel = new JLabel("Plants   ");
		JPanel choiceCrossSectionPanel = new JPanel();
		JLabel choiceCrossSectionLabel = new JLabel("Moose");
		JPanel choiceComputationalPlanePanel = new JPanel();
		JLabel choiceComputationalPlaneLabel = new JLabel("Predators");
		JPanel bottomPanel = new JPanel();
		
		isosurfacelist = new JList(plants);
		crossSectionlist = new JList(moose);
		computationalPlaneList = new JList(predators);
		
		isosurfacelist.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		crossSectionlist.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		computationalPlaneList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
		
		choiceIsosurfacePanel.setLayout(new BoxLayout(choiceIsosurfacePanel, BoxLayout.Y_AXIS));
		choiceIsosurfacePanel.setBorder(new EtchedBorder());
		choiceCrossSectionPanel.setLayout(new BoxLayout(choiceCrossSectionPanel, BoxLayout.Y_AXIS));
		choiceCrossSectionPanel.setBorder(new EtchedBorder());
		choiceComputationalPlanePanel.setLayout(new BoxLayout(choiceComputationalPlanePanel, BoxLayout.Y_AXIS));
		choiceComputationalPlanePanel.setBorder(new EtchedBorder());
		
		JScrollPane isosurfaceScrollPane = new JScrollPane();
		JScrollPane crossSectionScrollPane = new JScrollPane();
		JScrollPane computationalPlaneScrollPane = new JScrollPane();
		
		isosurfaceScrollPane.setViewportView(isosurfacelist);
		crossSectionScrollPane.setViewportView(crossSectionlist);
		computationalPlaneScrollPane.setViewportView(computationalPlaneList);
		
		isosurfaceScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		crossSectionScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		computationalPlaneScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		
		choiceIsosurfacePanel.add(choiceIsoSurfaceLabel);
		choiceCrossSectionPanel.add(choiceCrossSectionLabel);
		choiceComputationalPlanePanel.add(choiceComputationalPlaneLabel);
		
		choiceIsosurfacePanel.add(isosurfaceScrollPane);
		choiceCrossSectionPanel.add(crossSectionScrollPane);
		choiceComputationalPlanePanel.add(computationalPlaneScrollPane);
		
		JButton buttonCancel = new JButton();
		JButton buttonRemove = new JButton();
		JButton buttonEdit = new JButton();
		JButton buttonProperties = new JButton();
		JSeparator buttonseparator = new JSeparator();
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		mainPanel.add(choiceIsosurfacePanel);
		mainPanel.add(choiceCrossSectionPanel);
		mainPanel.add(choiceComputationalPlanePanel);
		//create button panel with a separator
		getContentPane().add(buttonseparator);
		
		
		buttonProperties.setText("Properties");
		buttonProperties.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			//buttonEditActionPerformed(evt);
		    }
		});
		bottomPanel.add(buttonProperties);
		
		buttonEdit.setText("Edit");
		buttonEdit.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			buttonEditActionPerformed(evt);
		    }
		});
		bottomPanel.add(buttonEdit);
		
		buttonRemove.setText("Remove");
		buttonRemove.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			buttonRemoveActionPerformed(evt);
		    }
		});
		bottomPanel.add(buttonRemove);
		
		JButton buttonRemoveAll = new JButton("Remove All");
		buttonRemoveAll.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			buttonRemoveAllActionPerformed(evt);
		    }
		});
		bottomPanel.add(buttonRemoveAll);
		
		buttonCancel.setText("Cancel");
		buttonCancel.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent evt) {
			buttonCancelActionPerformed();
		    }
		});
		bottomPanel.add(buttonCancel);
		bottomPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		bottomPanel.setSize(300, 30);
		containerPanel.add(mainPanel);
		getContentPane().add(containerPanel);
		getContentPane().add(bottomPanel);
		
        	pack();
    	}
    	
    	/**
	* Future ehancements
    	* The three methods below enable the user to add/remove components dynamically by updating appropriate vectors
    	*/
/*    	public void updateIsoSurfaceVector(){
	        isosurfacelist.setListData(VisualizationPanel.colorisosurfaceNames);
		mainPanel.repaint();
    	}
    	
	public void updateCrossSectionVector(){
	    	crossSectionlist.setListData(VisualizationPanel.cutNames);
		mainPanel.repaint();
	}
	
	public void updateComputationalPlaneVector(){
	    	computationalPlaneList.setListData(VisualizationPanel.computationalPlaneNames);
		mainPanel.repaint();
	}
*/	
//	public void updateMainPanel(){
//		updateIsoSurfaceVector();
//		updateCrossSectionVector();
//		updateComputationalPlaneVector();
//	}
	
	
	/**
	* Actions performed when "Remove" button is pressed.
	*/
	private void buttonRemoveActionPerformed(ActionEvent evt) {
/*		int[] indices = isosurfacelist.getSelectedIndices();
		if (indices != null) {
			for (int i = indices.length - 1; i >= 0; i--) {
				String tempString = ((String)VisualizationPanel.colorisosurfaceNames.elementAt(indices[i])).trim();
				sendMessage(new GroupUpdateVisualizationRemoveColorIsosurfaceMessage( tempString ));
			}
		}
		int[] indicesC = crossSectionlist.getSelectedIndices();
		if (indicesC != null) {
			for (int i = indicesC.length - 1; i >= 0; i--) {
				String tempStringC = ((String)VisualizationPanel.cutNames.elementAt(indicesC[i])).trim();
				sendMessage(new GroupUpdateVisualizationRemoveCutMessage( tempStringC ));
			}
		}
		int[] indicesCC = computationalPlaneList.getSelectedIndices();
		if (indicesCC != null) {
			for (int i = indicesCC.length - 1; i >= 0; i--) {
				String tempStringCC = ((String)VisualizationPanel.computationalPlaneNames.elementAt(indicesCC[i])).trim();
				sendMessage(new GroupUpdateVisualizationRemoveComputationalPlaneMessage( tempStringCC ));
			}
		}
*/	}
	
	
	/**
	* Actions performed when "Remove All" button is pressed. - all isosurfaces are removed
	*/
	private void buttonRemoveAllActionPerformed(ActionEvent evt) {
	/*	sendMessage(new GroupUpdateVisualizationRemoveAllMessage());
		sendMessage(new GroupUpdateVisualizationOutlineOnMessage());
	*/}
	
	
	/**
	*Actions performed when  "AddToPresets" button is pressed.
	*/
	private void buttonEditActionPerformed(ActionEvent evt) {
/*		int count = 0;
		int[] indices = isosurfacelist.getSelectedIndices();
		if (indices != null) {
			for (int i = indices.length - 1; i >= 0; i--) {
				String tempString = ((String)VisualizationPanel.colorisosurfaceNames.elementAt(indices[i])).trim();
				((visualizationFrame)(visualizationFrame.getFrame())).releaseEditColorIsosurfaceFrame(new EditColorIsosurfaceFrame(parent, tempString, vtkpanel, indices.length - i));
				count++;
			}
		}
		
	        int[] indicesC = crossSectionlist.getSelectedIndices();
		if (indicesC != null) {
			for (int i = indicesC.length - 1; i >= 0; i--) {
				String tempStringC = ((String)VisualizationPanel.cutNames.elementAt(indicesC[i])).trim();
				((visualizationFrame)(visualizationFrame.getFrame())).releaseEditCutFrame(new EditCutFrame(parent, tempStringC, vtkpanel, count + indicesC.length - i));
				count++;
			}
		}
		
		 int[] indicesCC = computationalPlaneList.getSelectedIndices();
		if (indicesCC != null) {
			for (int i = indicesCC.length - 1; i >= 0; i--) {
				String tempStringCC = ((String)VisualizationPanel.computationalPlaneNames.elementAt(indicesCC[i])).trim();
				((visualizationFrame)(visualizationFrame.getFrame())).releaseEditComputationalPlaneFrame(new EditComputationalPlaneFrame(parent, tempStringCC, vtkpanel, count + indicesCC.length - i));
			}
		}
  */  	}
    	
    	
	/**
	*Actions performed when  "AddToPresets" button is pressed.
	*/
	public void buttonCancelActionPerformed() {
//	    ((visualizationFrame)(visualizationFrame.getFrame())).removeManageComponentsPL3DFrame();
	    dispose();
//    	    ApplicationBar.removeWindowFromWindowsLinkedList(this);
    	}
    	
    	
	
}
 /*
public class PMPSimAgentsFrame extends JFrame{
	
	private JSeparator jSeparator2;
	private JLabel PredatorTopLabel;
	private JLabel MooseTopLabel;
	private JTextArea jTextArea111;
	private JPanel PlantsPanel;
	private JPanel jPanel2;
	private JLabel PlantsTopLabel;
	private JPanel jPanel22;
	private JTextArea jTextArea1;
	private JPanel MoosePanel;
	private JPanel jPanel21;
	private JPanel jPanel1;
	private JTextArea jTextArea11;
	private JPanel PredatorPanel;
	private JSeparator jSeparator3;
	
	 Constructor for the PMPSimAgentsFrame object
	 
	public PMPSimAgentsFrame() {
		super("Agents Currently Active");
		
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		setIconImage(new ImageIcon("images/visualization16.png").getImage());
		
	        jPanel1 = new JPanel();
		PlantsPanel = new JPanel();
		PlantsTopLabel = new JLabel();
		jTextArea1 = new JTextArea();
		jPanel2 = new JPanel();
		jSeparator2 = new JSeparator();
		MoosePanel = new JPanel();
		MooseTopLabel = new JLabel();
		jTextArea11 = new JTextArea();
		jPanel21 = new JPanel();
		jSeparator3 = new JSeparator();
		PredatorPanel = new JPanel();
		PredatorTopLabel = new JLabel();
		jTextArea111 = new JTextArea();
		jPanel22 = new JPanel();
		
		getContentPane().setLayout(new java.awt.BorderLayout());
		
		jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.X_AXIS));
		
		PlantsPanel.setLayout(new BoxLayout(PlantsPanel, BoxLayout.Y_AXIS));
		
		PlantsTopLabel.setText("jLabel1");
		PlantsPanel.add(PlantsTopLabel);
		
		PlantsPanel.add(jTextArea1);
		
		PlantsPanel.add(jPanel2);
		
		jPanel1.add(PlantsPanel);
		
		jPanel1.add(jSeparator2);
		
		MoosePanel.setLayout(new BoxLayout(MoosePanel, BoxLayout.Y_AXIS));
		
		MooseTopLabel.setText("jLabel1");
		MoosePanel.add(MooseTopLabel);
		
		MoosePanel.add(jTextArea11);
		
		MoosePanel.add(jPanel21);
		
		jPanel1.add(MoosePanel);
		
		jPanel1.add(jSeparator3);
		
		PredatorPanel.setLayout(new BoxLayout(PredatorPanel, BoxLayout.Y_AXIS));
		
		PredatorTopLabel.setText("jLabel1");
		PredatorPanel.add(PredatorTopLabel);
		
		PredatorPanel.add(jTextArea111);
		
		PredatorPanel.add(jPanel22);
		
		jPanel1.add(PredatorPanel);
		
		getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);
		
		this.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
			dispose();
		}
		});
		pack();
	}
	
	public void closeFrame() {
		dispose();
	}
}*/
