import java.awt.*;
import java.awt.event.*;

import java.lang.Thread;
import java.util.*;
import java.util.Hashtable;

/**
 * Description of the Class
 *
 * This is the main object of the PMPSim system. Its purpose is to hold all the parameters and characteristics associated with any 
 * given simulation setup
 *
 *@author    Anastasia Mironova
 *@created   February 21, 2003
 */
public class PMPSim{
	/** Variables declaration
	*/
	//these are the tables to store plants, moose, predators objects
	private static Hashtable plantsHashtable;
	private static Hashtable mooseHashtable;
	private static Hashtable predatorsHashtable;
	private static String[] plantsArray;
	private static String[] mooseArray;
	private static String[] predatorsArray;
	
	private Landscape landscape;
	
	/**
	Default Constructor, initialize all the varibles only, more detailed characteristics are specified using the set/get methods 
	*/
	
	public PMPSim(){
		plantsHashtable = new Hashtable();
		mooseHashtable = new Hashtable();
		predatorsHashtable = new Hashtable();
	}
	
	/*
	Initializes the landscape object
	Requires specification of some landscape dimensions
	*/
	public void initializeLandscape(Dimension landscapeGridDimensions){
		landscape = new Landscape(landscapeGridDimensions);
	}
	
	/*
	Extract the landscape object
	*/
	public Landscape getLandscape(){
		return landscape;
	}
	
	/*
	Methods for adding the agents to the hash tables of the simulation
	*/
	public void addPlant(Plant plantIn){
		plantsHashtable.put(plantIn.getId(), plantIn);
	}
	
	public void addMoose(Moose mooseIn){
		mooseHashtable.put(mooseIn.getId(), mooseIn);
	}
	
	public void addPredator(Predator predatorIn){
		predatorsHashtable.put(predatorIn.getId(), predatorIn);
	}
	
	
	/* 
	Methods for extracting the agent objects from the hash tables
	*/
	public Plant getPlant(String idIn){
		return (Plant)plantsHashtable.get(idIn);
	}
	
	public Moose getMoose(String idIn){
		return (Moose)mooseHashtable.get(idIn);
	}
	
	public Predator getPredator(String idIn){
		return (Predator)predatorsHashtable.get(idIn);
	}
}
