import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import java.util.Vector;

/**

Description of class

Abandoned idea of creating a separate panel for the landscape, however it may come in handy later, hence this has been kept

Date: 2/21/04
Author: Anastasia Mironova

The purpose of this class is to represent part the landscape model for the PMPSim system
*/

public class LandscapeModel extends JPanel implements MouseListener, MouseMotionListener{
	private Landscape landscape;
	
	private int prevX, prevY;     // The previous location of the mouse.
	
	private boolean dragging;      // This is set to true while the user is drawing.
	
	private Graphics graphicsForDrawing;  // A graphics context for the applet
	                                         // that is used to draw the user's curve.
						 
	
	public LandscapeModel(Landscape l){
		super();
		
		//initialize landscape 
		landscape = l;
		
		setLayout(new BorderLayout());
		setBorder(new LineBorder(new Color(0, 0, 0)));
		
		addMouseListener(this);
		addMouseMotionListener(this);
	}
	
	public void mousePressed(MouseEvent evt) {
           // This is called when the user presses the mouse on the
           // canvas.  This begins a draw operation in which the user
           // sketches a curve.

      if (dragging == true)  // Ignore mouse presses that occur
          return;            //    when user is already drawing a curve.
                             //    (This can happen if the user presses
                             //    two mouse buttons at the same time.)

      prevX = evt.getX();    // Start drawing.
      prevY = evt.getY();
      dragging = true;
      graphicsForDrawing = getGraphics();
      graphicsForDrawing.setColor(Color.BLACK);

   } // end mousePressed()


   public void mouseReleased(MouseEvent evt) {
           // Called whenever the user releases the mouse button.
           // If the user was drawing a curve, the curve is done,
           // so we should set drawing to false and get rid of
           // the graphics context that we created to use during
           // the drawing.
       if (dragging == false)
          return;  // Nothing to do because the user isn't drawing.
       dragging = false;
       graphicsForDrawing.dispose();
       graphicsForDrawing = null;
   }


   public void mouseDragged(MouseEvent evt) {
            // Called whenever the user moves the mouse
            // while a mouse button is held down.  If the
            // user is drawing, draw a line segment from the
            // previous mouse location to the current mouse
            // location, and set up prevX and prevY for the
            // next call.

       if (dragging == false)
          return;  // Nothing to do because the user isn't drawing.

       int x = evt.getX();   // x-coordinate of mouse.
       int y = evt.getY();   // y=coordinate of mouse.

       graphicsForDrawing.drawLine(prevX, prevY, x, y);  // Draw the line.

       prevX = x;  // Get ready for the next line segment in the curve.
       prevY = y;

   } // end mouseDragged.

	public void mouseEntered(MouseEvent evt) { }   // Some empty routines.
	public void mouseExited(MouseEvent evt) { }    //    (Required by the MouseListener
	public void mouseClicked(MouseEvent evt) { }   //    and MouseMotionListener
	public void mouseMoved(MouseEvent evt) { }     //    interfaces).
		
	/**
	Overriding the default to draw the components
	*/
	public void paintComponent(Graphics g){
		Graphics2D g2 = (Graphics2D) g;
		super.paintComponent(g2);
		
		//draw all the vertical lines
		for (int i = 1; i <= (int)(landscape.getGridDimensions().getWidth());i++){
			g.drawLine(i*((int)(LandscapeSegment.getDimensions().getWidth())), 0, i*((int)(LandscapeSegment.getDimensions().getWidth())), (int)(this.getSize().getHeight()));
		}
		//draw all the horizontal lines
		for (int i = 1; i <= (int)(landscape.getGridDimensions().getHeight());i++){
			g.drawLine(0, i*((int)(LandscapeSegment.getDimensions().getHeight())), (int)(this.getSize().getHeight()), i*((int)(LandscapeSegment.getDimensions().getHeight())));
		}
		
	
	}
}
