import java.awt.*;
import java.awt.event.*;
import java.math.BigInteger;
import javax.swing.*;
import javax.swing.border.*;

/**
Date: 1/23/04
Author: Anastasia Mironova

The purpose of this class is to represent the landscape model for the PMPSim system
*/

public class LandscapeContainerPanel extends JPanel{
	private Landscape landscape;
	private LandscapeSegment activeSegment;
	private JFrame activeSegmentFrame;
	/**
	Constructs a new instance of LandscapeContainerPanel
	*/
	public LandscapeContainerPanel(Landscape landscapeIn){
		//instantiate the panel
		super();
		setLayout(new BorderLayout());
		
		
		//Create landscape
		landscape = landscapeIn;
		landscape.setParentPanel(this);
		//landscape.setPreferredSize(new Dimension(100, 100));//Landscape.dimensions);
		this.add(landscape);
		
		//Create landscape segment
		activeSegmentFrame = new JFrame();
		JPanel segmentHolder = new JPanel();
		segmentHolder.setLayout(new BorderLayout());
		activeSegment = landscape.getCopyOfSegment(new Location(1, 1));
		activeSegment.setPreferredSize(LandscapeSegment.getDimensions());//Landscape.dimensions);
		segmentHolder.add(activeSegment);
		activeSegmentFrame.getContentPane().add(segmentHolder);
		
		activeSegmentFrame.show();
		
		
		this.setPreferredSize(new Dimension(
							(int)((landscape.getGridDimensions().getWidth())*(LandscapeSegment.getDimensions().getWidth())), 
							(int)((landscape.getGridDimensions().getHeight())*(LandscapeSegment.getDimensions().getWidth()))));
		
		
		//activeSegmentFrame.setSize(100, 100);//LandscapeSegment.getSideLength());
	}
	
	/**
	This method perfotms a swap between the panels
	Takes in the location of a panel desired to be swapped
	Sets all the parameters of the current segment to the ones in the array
	Gets a copy of the segment at the specified location and change the active segment to a copy of that one
	
	*/
	public void performPanelSwap(Location l){
		System.out.println("" + "x: " + l.getXCoordinate() + " y: " + l.getYCoordinate());
		//"put" the currently active segment "back" in the landscape array
		landscape.getSegment(activeSegment.getLocationInLandscapeGrid()).makeLike(activeSegment);
		//reset the desired segment to be active
		activeSegment.makeLike(landscape.getCopyOfSegment(l));
		activeSegment.setPreferredSize(landscape.getSize());
		activeSegment.repaint();
		activeSegmentFrame.repaint();
	}
}
