/**
 * AdvancedLandscapeSpecificationsFrame
 * This forms allows for the specification of the advanced characteristics for the ladnscape model
 *
 * Created on 25 March 2004, 10:18
 * 
 * @author  Anastasia V Mironova
 */
 
 import javax.swing.*;
 import javax.swing.border.*;
 import java.awt.*;
 import java.awt.event.*;
 import java.awt.geom.*;
 
 import java.util.Vector;
 
public class AdvancedLandscapeSpecificationsFrame extends JFrame {
    // Variables declaration
    private BasicLandscapeParametersPanel topPanel;
    private JPanel buttonsPanel;
    private JButton submitButton;
    private Landscape landscapeModelPanel;
    private JButton cancelButton;
    private JButton toolBarButton;
    private JPanel mainPanel;
    
    private LandscapeToolBarFrame toolBar;
    
    private PMPSim simulation;
    // End of variables declaration
    
    /**
    Creates new form AdvancedLandscapeSpecificationsFrame 
    */
    public AdvancedLandscapeSpecificationsFrame(PMPSim s) {
	super("Advanced Landscape Specifications");
        //set the simulation
	simulation = s;
	
	topPanel = new BasicLandscapeParametersPanel((int)(simulation.getLandscape().getGridDimensions().getWidth()),
							(int)(simulation.getLandscape().getGridDimensions().getHeight()), 
							(LandscapeSegment.getLengthIncrement()));
	
	landscapeModelPanel = simulation.getLandscape();// new LandscapeModel(simulation.getLandscape());
	
	mainPanel = new JPanel();
	buttonsPanel = new JPanel();
        toolBarButton = new JButton();
        submitButton = new JButton();
        cancelButton = new JButton();
	
	getContentPane().setLayout(new BorderLayout());
	
	mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));
	mainPanel.setBorder(new TitledBorder("Landscape"));
	
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                exitForm();
            }
        });
	
        mainPanel.add(topPanel);
	
	landscapeModelPanel.setPreferredSize(new Dimension(
							(int)((simulation.getLandscape().getGridDimensions().getWidth())*(LandscapeSegment.getDimensions().getWidth())),
							(int)((simulation.getLandscape().getGridDimensions().getHeight())*(LandscapeSegment.getDimensions().getHeight()))));
	
	mainPanel.add(landscapeModelPanel);
	
        buttonsPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
	
        toolBarButton.setText("Hide ToolBar");
	toolBarButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e){
			if (toolBar.isEnabled()){
				hideToolBar();
			} else {
				showToolBar();
			}
		}
	});
        buttonsPanel.add(toolBarButton);
	
        submitButton.setText("Submit");
        buttonsPanel.add(submitButton);
	
        cancelButton.setText("Cancel");
	cancelButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e){
			exitForm();
		}
	});
        buttonsPanel.add(cancelButton);
	
        mainPanel.add(buttonsPanel);
	
	getContentPane().add(mainPanel);
	
	//initialize the toolBar frame
	toolBar = new LandscapeToolBarFrame(((int)((simulation.getLandscape().getGridDimensions().getWidth())*(LandscapeSegment.getDimensions().getWidth()))+ 15));
	toolBar.show();
	
        pack();
    }
    
    /*
    Cancel all changes
    */
    private void exitForm() {
        hideToolBar();
	dispose();
    }
    
    /* enables the user to draw elevation contours
    */
    public void elevationContourSetUp(){
	    landscapeModelPanel.enableModifications(true);
	    landscapeModelPanel.setCurrentColor(Landscape.elevationContourColor);
    }
    
    public void elevationContourViewAll(){
	    landscapeModelPanel.viewElevationContours();
    }
    
    
    public void waterPatchSetUp(){
	    landscapeModelPanel.enableModifications(true);
	    landscapeModelPanel.setCurrentColor(Landscape.waterPatchColor);
    }
    
    public void waterPatchViewAll(){
	    landscapeModelPanel.viewWaterPatches();
    }
    
    
    /*view riparian paches
    */
    public void riparianPatchSetUp(){
	    landscapeModelPanel.enableModifications(true);
	    landscapeModelPanel.setCurrentColor(Landscape.riparianHabitatColor);
    }
    
    public void riparianPatchViewAll(){
	    landscapeModelPanel.viewRiparianPatches();
    }
    
    /*view forest patches
    */
    public void forestPatchSetUp(){
	    landscapeModelPanel.enableModifications(true);
	    landscapeModelPanel.setCurrentColor(Landscape.forestHabitatColor);
    }
    
    public void forestPatchViewAll(){
	    landscapeModelPanel.viewForestPatches();
    }
    
    
    public void toDefaultView(){
	    landscapeModelPanel.viewDefault();
    }
    
    /**
    Methods for hiding and showing the toolbar frame
    */
    public void hideToolBar(){
	    toolBar.hide();
	    toolBar.setEnabled(false);
	    toolBarButton.setText("Show ToolBar");
    }
    
    public void showToolBar(){
	    toolBar.setEnabled(true);
	    toolBar.show();
	    toolBarButton.setText("Hide ToolBar");
    }
    
//the toolbar class
class LandscapeToolBarFrame extends JFrame {
    // Variables declaration 
    private JLabel elevationContoursLabel;
    private JComboBox speciesComboBox;
    private JPanel elevationContoursButtonPanel;
    private JPanel riversStreamsLabelPanel;
    private JPanel waterPanel;
    private JButton riversStreamsButton;
    private JLabel patchesLabel;
    private JPanel riversStreamsButtonPanel;
    private JPanel patchesForSpeciesPanel;
    private JPanel patchesPanel;
    private JPanel patchesContainerPanel;
    private JPanel elevationContoursLabelPanel;
    private JPanel elevationPanel;
    private JPanel patchesButtonPanel;
    private JButton elevationContoursButton;
    private JPanel elevationContoursContainerPanel;
    private JPanel elevationContoursPanel;
    private JPanel waterContainerPanel;
    private JButton patchesButton;
    private JLabel riversStreamsLabel;
    private JPanel patchesforSpeciesContainerPanel;
    private JPanel waterSecondContainerPanel;
    private JButton elevationContoursViewButton;
    private JButton riversStreamsViewButton;
    private JPanel selectViewLabelPanel;
    private JLabel selectViewLabel;
    private JComboBox viewSelectionBox;
    private JPanel selectionBoxPanel;
    private JPanel viewPanel;

    private JPanel riparianPanel;
    private JPanel riparianContainerPanel;
    private JPanel riparianSecondContainerPanel;
    private JPanel riparianHabitatLabelPanel;
    private JLabel riparianHabitatLabel;
    private JPanel riparianHabitatButtonPanel;
    private JButton riparianHabitatButton;
	
    private JPanel forestPanel;
    private JPanel forestContainerPanel;
    private JPanel forestSecondContainerPanel;
    private JPanel forestHabitatLabelPanel;
    private JLabel forestHabitatLabel;
    private JPanel forestHabitatButtonPanel;
    private JButton forestHabitatButton;
    
    private Vector plantSpecies;
    private Vector viewOptions;
    // End of variables declaration
    
    /** Creates new form LandscapeToolBarFrame */
    public LandscapeToolBarFrame( int xCoordinateOfLocation) {
        super("Landscape ToolBar");
	
	//set location of the frame
	setLocation(xCoordinateOfLocation, 0);
	
	elevationPanel = new JPanel();
        elevationContoursPanel = new JPanel();
        elevationContoursContainerPanel = new JPanel();
        elevationContoursLabelPanel = new JPanel();
        elevationContoursLabel = new JLabel();
        elevationContoursButtonPanel = new JPanel();
        elevationContoursButton = new JButton();
        waterPanel = new JPanel();
        waterContainerPanel = new JPanel();
        waterSecondContainerPanel = new JPanel();
        riversStreamsLabelPanel = new JPanel();
        riversStreamsLabel = new JLabel();
        riversStreamsButtonPanel = new JPanel();
        riversStreamsButton = new JButton();
        patchesPanel = new JPanel();
        patchesContainerPanel = new JPanel();
        patchesForSpeciesPanel = new JPanel();
        patchesforSpeciesContainerPanel = new JPanel();
        patchesLabel = new JLabel();
        patchesButtonPanel = new JPanel();
        patchesButton = new JButton();
	elevationContoursViewButton = new JButton();
	riversStreamsViewButton = new JButton();
	
	riparianPanel = new JPanel();
	riparianContainerPanel = new JPanel();
	riparianSecondContainerPanel = new JPanel();
	riparianHabitatLabelPanel = new JPanel();
	riparianHabitatLabel = new JLabel();
	riparianHabitatButtonPanel = new JPanel();
	riparianHabitatButton = new JButton();
	
	forestPanel = new JPanel();
	forestContainerPanel = new JPanel();
	forestSecondContainerPanel = new JPanel();
	forestHabitatLabelPanel = new JPanel();
	forestHabitatLabel = new JLabel();
	forestHabitatButtonPanel = new JPanel();
	forestHabitatButton = new JButton();
	
        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
	
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent evt) {
                exitForm(evt);
            }
        });

        elevationPanel.setLayout(new BorderLayout());

        elevationPanel.setBorder(new TitledBorder("Elevation"));
        elevationContoursPanel.setLayout(new BorderLayout());

        elevationContoursContainerPanel.setLayout(new BoxLayout(elevationContoursContainerPanel, BoxLayout.X_AXIS));

        elevationContoursContainerPanel.setBorder(new EtchedBorder());
        elevationContoursLabelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));

        elevationContoursLabel.setText("Elevation Contours");
        elevationContoursLabelPanel.add(elevationContoursLabel);

        elevationContoursContainerPanel.add(elevationContoursLabelPanel);

        elevationContoursButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));

        
	elevationContoursButton.setText("Draw");
	elevationContoursButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e){
			toDefaultView();
			elevationContourSetUp();
		}
	});
        elevationContoursButtonPanel.add(elevationContoursButton);
	
	elevationContoursContainerPanel.add(elevationContoursButtonPanel);
	
        elevationContoursPanel.add(elevationContoursContainerPanel, BorderLayout.CENTER);
	
        elevationPanel.add(elevationContoursPanel, BorderLayout.NORTH);
	
        getContentPane().add(elevationPanel);
	
	
	/*Set up wetlands panel
	*/
        waterPanel.setLayout(new BorderLayout());
	
        waterPanel.setBorder(new TitledBorder("Bogs/Wetlands"));
        waterContainerPanel.setLayout(new BorderLayout());
	
        waterSecondContainerPanel.setLayout(new BoxLayout(waterSecondContainerPanel, BoxLayout.X_AXIS));
	
        waterSecondContainerPanel.setBorder(new EtchedBorder());
        riversStreamsLabelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	
        riversStreamsLabel.setText("Wetland Habitats");
        riversStreamsLabelPanel.add(riversStreamsLabel);
	
        waterSecondContainerPanel.add(riversStreamsLabelPanel);
	
        riversStreamsButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
	
        riversStreamsButtonPanel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        
	riversStreamsButton.setText("Draw");
	riversStreamsButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e){
			toDefaultView();
			waterPatchSetUp();
		}
	});
        riversStreamsButtonPanel.add(riversStreamsButton);
	
        waterSecondContainerPanel.add(riversStreamsButtonPanel);
	
        waterContainerPanel.add(waterSecondContainerPanel, BorderLayout.CENTER);
	
        waterPanel.add(waterContainerPanel, BorderLayout.NORTH);
	
        getContentPane().add(waterPanel);
	
	
	
	/*Setup riparian habitat panel
	*/
	riparianPanel.setLayout(new BorderLayout());
	
        riparianPanel.setBorder(new TitledBorder("Riparian"));
        riparianContainerPanel.setLayout(new BorderLayout());
	
        riparianSecondContainerPanel.setLayout(new BoxLayout(riparianSecondContainerPanel, BoxLayout.X_AXIS));
	
        riparianSecondContainerPanel.setBorder(new EtchedBorder());
        riparianHabitatLabelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	
        riparianHabitatLabel.setText("Riparian Habitats");
        riparianHabitatLabelPanel.add(riparianHabitatLabel);
	
        riparianSecondContainerPanel.add(riparianHabitatLabelPanel);
	
        riparianHabitatButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
	
        riparianHabitatButtonPanel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        
	riparianHabitatButton.setText("Draw");
	riparianHabitatButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e){
			toDefaultView();
			riparianPatchSetUp();
		}
	});
        riparianHabitatButtonPanel.add(riparianHabitatButton);
	
        riparianSecondContainerPanel.add(riparianHabitatButtonPanel);
	
        riparianContainerPanel.add(riparianSecondContainerPanel, BorderLayout.CENTER);
	
        riparianPanel.add(riparianContainerPanel, BorderLayout.NORTH);
	
        getContentPane().add(riparianPanel);
	
	
	
	/*Setup riparian habitat panel
	*/
	forestPanel.setLayout(new BorderLayout());
	
        forestPanel.setBorder(new TitledBorder("Forest"));
        forestContainerPanel.setLayout(new BorderLayout());
	
        forestSecondContainerPanel.setLayout(new BoxLayout(forestSecondContainerPanel, BoxLayout.X_AXIS));
	
        forestSecondContainerPanel.setBorder(new EtchedBorder());
        forestHabitatLabelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	
        forestHabitatLabel.setText("Forest Habitats");
        forestHabitatLabelPanel.add(forestHabitatLabel);
	
        forestSecondContainerPanel.add(forestHabitatLabelPanel);
	
        forestHabitatButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
	
        forestHabitatButtonPanel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        
	forestHabitatButton.setText("Draw");
	forestHabitatButton.addActionListener(new ActionListener(){
		public void actionPerformed(ActionEvent e){
			toDefaultView();
			forestPatchSetUp();
		}
	});
        forestHabitatButtonPanel.add(forestHabitatButton);
	
        forestSecondContainerPanel.add(forestHabitatButtonPanel);
	
        forestContainerPanel.add(forestSecondContainerPanel, BorderLayout.CENTER);
	
        forestPanel.add(forestContainerPanel, BorderLayout.NORTH);
	
        getContentPane().add(forestPanel);
	
	
	
	
	
	/* Set up the patches panel
	*/
        patchesPanel.setLayout(new BorderLayout());
	
        patchesPanel.setBorder(new TitledBorder("Patches"));
        patchesContainerPanel.setLayout(new BoxLayout(patchesContainerPanel, BoxLayout.Y_AXIS));
	
        patchesContainerPanel.setBorder(new EtchedBorder());
        patchesForSpeciesPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	
        patchesforSpeciesContainerPanel.setLayout(new BoxLayout(patchesforSpeciesContainerPanel, BoxLayout.X_AXIS));
	
        patchesLabel.setText("Define Patch For               ");
        patchesforSpeciesContainerPanel.add(patchesLabel);
	
	plantSpecies = new Vector();
	plantSpecies.addElement("Salix pulchra");
	plantSpecies.addElement("Salix alaxensis");
	plantSpecies.addElement("Populus tremuloides");
	plantSpecies.addElement("Betula nana");
	
	speciesComboBox = new JComboBox(plantSpecies);
        
        patchesforSpeciesContainerPanel.add(speciesComboBox);
	
        patchesForSpeciesPanel.add(patchesforSpeciesContainerPanel);
	
        patchesContainerPanel.add(patchesForSpeciesPanel);
	
        patchesButtonPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
	
        patchesButton.setText("Draw");
        patchesButtonPanel.add(patchesButton);
	
        patchesContainerPanel.add(patchesButtonPanel);
	
        patchesPanel.add(patchesContainerPanel, BorderLayout.CENTER);
	
	getContentPane().add(patchesPanel);
	
	//create View panel
	viewPanel = new JPanel();
	
	selectViewLabelPanel = new JPanel();
        selectViewLabel = new JLabel();
        selectionBoxPanel = new JPanel();
        
	//define selection box
        viewOptions = new Vector();
	
	viewOptions.addElement("Default");
	viewOptions.addElement("Elevation Contours");
	viewOptions.addElement("Bogs/Wetlands");
	viewOptions.addElement("Riparian");
	viewOptions.addElement("Forest");
	
	for (int i = 1; i<= plantSpecies.size();i++){
		viewOptions.addElement(plantSpecies.elementAt(i-1));
	}
	
	viewSelectionBox = new JComboBox(viewOptions);
	viewSelectionBox.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
			viewSelected(evt);
		}
	});
	
        viewPanel.setLayout(new BoxLayout(viewPanel, BoxLayout.X_AXIS));
	
        viewPanel.setBorder(new EtchedBorder());
        selectViewLabelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
	
        selectViewLabel.setText("Select View ");
        selectViewLabelPanel.add(selectViewLabel);
	
        viewPanel.add(selectViewLabelPanel);
	
        selectionBoxPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
	
        selectionBoxPanel.add(viewSelectionBox);
	
        viewPanel.add(selectionBoxPanel);
	
	getContentPane().add(viewPanel);
	
        pack();
    }
    
    //allows the user to select different views of the landscape
    private void viewSelected(ActionEvent evt){
	    JComboBox cb = (JComboBox)evt.getSource();
	    if ("comboBoxChanged".equals(evt.getActionCommand())) {
		if (((String)cb.getSelectedItem()).equals("Default")) {
				toDefaultView();
			} else if (((String)cb.getSelectedItem()).equals("Elevation Contours")){
				elevationContourViewAll();
			} else if (((String)cb.getSelectedItem()).equals("Bogs/Wetlands")){
				waterPatchViewAll();
			} else if (((String)cb.getSelectedItem()).equals("Riparian")){
				riparianPatchViewAll();
			} else if (((String)cb.getSelectedItem()).equals("Forest")){
				forestPatchViewAll();
			}
	    }
	    viewPanel.repaint();
    }
    
    /** hide the toolBar */
    private void exitForm(WindowEvent evt) {
        hideToolBar();
    }
}




}

