Public Class Form1
    Inherits System.Windows.Forms.Form

    Dim countDown As Integer        ' Use to make a countdown from 5 to 0
    Dim startTime As Date           ' Used to compute time it takes for the user to answer
    Dim question As String          ' Question to ask the user
    ' *** TODO: CHANGE THE LINE ABOVE TO MAKE QUESTION INTO AN ARRAY
    Dim current As Integer          ' Index into the array above to track the current question to ask


#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents btnStart As System.Windows.Forms.Button
    Friend WithEvents lstResults As System.Windows.Forms.ListBox
    Friend WithEvents lblResults As System.Windows.Forms.Label
    Friend WithEvents lblInstructions As System.Windows.Forms.Label
    Friend WithEvents timerCountdown As System.Windows.Forms.Timer
    Friend WithEvents timerTimeToAnswer As System.Windows.Forms.Timer
    Friend WithEvents lblCountdown As System.Windows.Forms.Label
    Friend WithEvents lblQuestion As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.btnStart = New System.Windows.Forms.Button
        Me.lstResults = New System.Windows.Forms.ListBox
        Me.lblResults = New System.Windows.Forms.Label
        Me.lblInstructions = New System.Windows.Forms.Label
        Me.timerCountdown = New System.Windows.Forms.Timer(Me.components)
        Me.timerTimeToAnswer = New System.Windows.Forms.Timer(Me.components)
        Me.lblCountdown = New System.Windows.Forms.Label
        Me.lblQuestion = New System.Windows.Forms.Label
        Me.SuspendLayout()
        '
        'btnStart
        '
        Me.btnStart.Location = New System.Drawing.Point(8, 56)
        Me.btnStart.Name = "btnStart"
        Me.btnStart.Size = New System.Drawing.Size(112, 40)
        Me.btnStart.TabIndex = 0
        Me.btnStart.Text = "Show Question"
        '
        'lstResults
        '
        Me.lstResults.Location = New System.Drawing.Point(8, 248)
        Me.lstResults.Name = "lstResults"
        Me.lstResults.Size = New System.Drawing.Size(408, 108)
        Me.lstResults.TabIndex = 1
        '
        'lblResults
        '
        Me.lblResults.Font = New System.Drawing.Font("Microsoft Sans Serif", 10.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblResults.Location = New System.Drawing.Point(8, 224)
        Me.lblResults.Name = "lblResults"
        Me.lblResults.Size = New System.Drawing.Size(216, 24)
        Me.lblResults.TabIndex = 2
        Me.lblResults.Text = "Results:"
        '
        'lblInstructions
        '
        Me.lblInstructions.Font = New System.Drawing.Font("Microsoft Sans Serif", 10.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblInstructions.Location = New System.Drawing.Point(8, 8)
        Me.lblInstructions.Name = "lblInstructions"
        Me.lblInstructions.Size = New System.Drawing.Size(296, 32)
        Me.lblInstructions.TabIndex = 3
        Me.lblInstructions.Text = "Answer each question as fast as you can.   Answer by pressing Y for yes and N for" & _
        " no."
        '
        'timerCountdown
        '
        '
        'lblCountdown
        '
        Me.lblCountdown.Font = New System.Drawing.Font("Microsoft Sans Serif", 10.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblCountdown.Location = New System.Drawing.Point(152, 56)
        Me.lblCountdown.Name = "lblCountdown"
        Me.lblCountdown.Size = New System.Drawing.Size(208, 40)
        Me.lblCountdown.TabIndex = 4
        Me.lblCountdown.Text = "lblCountdown"
        Me.lblCountdown.Visible = False
        '
        'lblQuestion
        '
        Me.lblQuestion.Font = New System.Drawing.Font("Microsoft Sans Serif", 12.0!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblQuestion.Location = New System.Drawing.Point(16, 120)
        Me.lblQuestion.Name = "lblQuestion"
        Me.lblQuestion.Size = New System.Drawing.Size(400, 88)
        Me.lblQuestion.TabIndex = 5
        Me.lblQuestion.Text = "lblQuestion"
        Me.lblQuestion.Visible = False
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(424, 365)
        Me.Controls.Add(Me.lblQuestion)
        Me.Controls.Add(Me.lblCountdown)
        Me.Controls.Add(Me.lblInstructions)
        Me.Controls.Add(Me.lblResults)
        Me.Controls.Add(Me.lstResults)
        Me.Controls.Add(Me.btnStart)
        Me.Name = "Form1"
        Me.Text = "Sentence Verification Experiment"
        Me.ResumeLayout(False)

    End Sub

#End Region

    ' The form load event is run once when the program is first started
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        question = "Is a petunia a plant?"
        ' *** TODO:  CHANGE THE LINE ABOVE TO LOAD QUESTIONS INTO THE QUESTION() ARRAY
        ' *** TODO:  SET current TO THE INDEX OF FIRST QUESTION
    End Sub

    ' This event is fired when the user clicks the "Show Question" button.
    ' Starts a countdown for five seconds to give the user time
    ' to get ready to answer the question
    Private Sub btnStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStart.Click
        timerCountdown.Interval = 1000      ' Set timer interval to 1 second
        countDown = 5                       ' Wait five seconds
        DisplayCountdown()
        timerCountdown.Enabled = True
    End Sub

    ' Display countdown message in the label
    Sub DisplayCountdown()
        lblCountdown.Visible = True
        lblCountdown.Text = "Get your fingers ready!  Question will appear in " & CStr(countDown) & " seconds."
    End Sub

    ' This is the timer event to create the countdown.
    ' This event is triggered every 1000 milliseconds.
    ' It decrements the counter by one unless we've hit zero, in which case we
    ' display the question.
    Private Sub timerCountdown_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCountdown.Tick
        If countDown > 0 Then
            ' Decrement counter
            countDown = countDown - 1
            DisplayCountdown()
            timerCountdown.Interval = 1000
            timerCountdown.Enabled = True       ' Start timer again for another 1 second
        Else
            ' Turn off the timer
            timerCountdown.Enabled = False
            ' Hide the label that shows the countdown
            lblCountdown.Visible = False
            ' Show the question
            ShowQuestion()
            ' Start timing how long it takes to answer
            startTime = Now
        End If
    End Sub

    ' Display current question on the form
    Sub ShowQuestion()
        lblQuestion.Visible = True
        lblQuestion.Text = question
        ' *** TODO:  CHANGE THE LINE ABOVE TO DISPLAY THE CURRENT QUESTION OUT OF THE ARRAY
    End Sub

    ' This event is triggered when the user presses a key to answer the question
    Private Sub btnStart_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles btnStart.KeyPress
        ' Compute time it took to answer
        Dim endTime As Date = Now
        Dim elapsedTime As TimeSpan = endTime.Subtract(startTime)
        Dim DifferenceInMilliSeconds As Long = CLng(elapsedTime.TotalMilliseconds)
        Beep()
        lstResults.Items.Add("Question: " & question & " You answered: " & CStr(e.KeyChar) _
                             & " in " & DifferenceInMilliSeconds & " milliseconds.")
        ' *** TODO: MODIFY LINE ABOVE TO OUTPUT CURRENT QUESTION
        ' Hide the question
        lblQuestion.Visible = False
        ' *** TODO:  INCREMENT current SO THE NEXT QUESTION WILL BE DISPLAYED NEXT.  
        ' *** TODO:  ALSO CHECK IF THIS WAS THE LAST QUESTION, AND IF SO, DISPLAY A MESSAGE AND
        ' *** TODO:  RESET current BACK TO THE FIRST QUESTION.
    End Sub
End Class
