/*****************************************************************
 * Quoridor 2-player version
 * CS441/541		1/2/98
 *
 * main implementation of quoridor
 *
 * Feel free to use/study any portions of this code that you
 * like for your own program.
 *
 * Here white is 'O' and black is 'X'.
 * Kenrick Mock
 *****************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

#include "globals.h"
#include "quoridor.h"

int BookMove(cell board[XDIM][YDIM], int iCompColor, char *m)
{
  if (iCompColor==WHITE)
  {
   if ((i_aryXLoc[WHITE]==4) && (i_aryYLoc[WHITE]==5) &&
       (i_aryXLoc[BLACK]==4) && (i_aryYLoc[BLACK]==3) &&
       (board[4][4].b==OPEN) &&
       (board[4][5].b==BLOCKED))
	{
	if (IsValidMove(board,"3 4 r",iCompColor))
	   { strcpy(m,"3 4 r"); return(1); }
	if (IsValidMove(board,"4 4 r",iCompColor))
	   { strcpy(m,"4 4 r"); return(1); }
	}
  }
 return(0);
}

/**************************** Main Program ***************************/
main()
{
 int i,iGameOver;
 char s[100];
 int iWhoseMove;
 int desty;
 char mlist[150][7];
 char best[10];
 int iMyColor,iHisColor;
 FILE *f;
 int iBlackDepth;
 int iWhiteDepth;
 int iBoth=0;

 iXNeighborhood=2; iYNeighborhood=1;
 iMoveNum=1;
 srandom(getpid());
 printf("\n\nWelcome to Quorky, an AI implementation of Quoridor(tm).\n\n");
 printf("There are two modes available.  Either the computer can play\n");
 printf("itself, or you can play against the computer to see if your\n");
 printf("Quoridor acumen can withstand the brute-force computational\n");
 printf("powers of Quorky.\n\n");
 printf("Aside from some entertainment value, the purpose of Quorky\n");
 printf("is to provide a benchmark of sorts for your own program.\n");
 printf("The heuristic is not particularly sophisticated, and the code\n");
 printf("is not particularly optimized.  Tournament-winning programs\n");
 printf("will likely beat Quorky, so you can use this as a measuring\n");
 printf("stick for your own program's performance.  Please note that if\n");
 printf("your program can't beat Quorky, you won't be penalized in any\n");
 printf("way.  Correctness of your algorithms, implementation on time,\n");
 printf("and your writeup will make up your project grade.\n\n");
 printf("Should the computer be White (O), Black (X), or Both (B)?\n");
 gets(s);
 if ((s[0]=='o') || (s[0]=='O')) 
 {
  iMyColor=WHITE;  iHisColor=BLACK;
 }
 else 
 {
  iMyColor=BLACK; iHisColor=WHITE;
 }
 if ((s[0]=='b') || (s[0]=='B')) 
 {
  iBoth=1;
  printf("\nEnter the ply lookahead for O (<=2 is fast, 3 is reasonable, 4+ is slow)\n");
  gets(s);
  sscanf(s,"%d",&iWhiteDepth);
  printf("\nEnter the ply lookahead for X (<=2 is fast, 3 is reasonable, 4+ is slow)\n");
  gets(s);
  sscanf(s,"%d",&iBlackDepth);
 }
 else
 {
  iBoth=0;
  printf("\nEnter the ply lookahead (<=2 is fast, 3 is reasonable, 4+ is slow)\n");
  gets(s);
  sscanf(s,"%d",&iDepth);
 }
 printf("\n\n");
 iGameOver=0;
 InitBoard(board);
 iWhoseMove=WHITE;
 while (!iGameOver)
 {
 	ShowBoard(board);
/*
	if (i_aryFences[WHITE]+i_aryFences[BLACK] == 0)
		iDepth=3;
	if (i_aryFences[WHITE]+i_aryFences[BLACK] < 8)
		{ iXNeighborhood=3; iYNeighborhood=3; }
*/
	
	if (iWhoseMove==WHITE) printf("%d:O's turn (white). ",iMoveNum);
  	else printf("%d:X's turn (black). ",iMoveNum);
	printf("u,d,l,r to move, X Y r/b for a fence, n if nomove:\n");
	if ((iWhoseMove==iMyColor) || (iBoth))
	{		
/*	  gets(s);   */
	strcpy(s,"!"); 
if (s[0]=='!') {
	  printf("Computer working...\n");
	  if (iBoth) {
		if (iWhoseMove==WHITE) {
			iDepth=iWhiteDepth;
	/*	 iXNeighborhood=3; iYNeighborhood=3; */
		}
		if (iWhoseMove==BLACK) {
			iDepth=iBlackDepth;
/*		 iXNeighborhood=2; iYNeighborhood=1;  */
		}
	  }
	  if (!BookMove(board, iMyColor , s)) {
            minvalue(board,iWhoseMove,iWhoseMove,-10001,10001,0,best);	
            if ((best[0]=='u') || (best[0]=='d') || (best[0]=='l') || (best[0]=='r')) {
               if ((i_aryXLoc[iWhoseMove]==i_aryLastXLoc[iWhoseMove]) &&
                   (i_aryYLoc[iWhoseMove]==i_aryLastYLoc[iWhoseMove]) &&
                   (i_aryLastWasMove[WHITE]) && (i_aryLastWasMove[BLACK])) {
	             i=iDepth; iDepth=1;
                     minvalue(board,iWhoseMove,iWhoseMove,-10001,10001,0,best);
                     iDepth=i;
	       }
	     }
	    strcpy(s,best);
	  }
	  printf("Computer moving to %s\n",s);
}
	}
	else
	{
	gets(s);   
/*	strcpy(s,"!");  */
if (s[0]=='!') {
	  printf("Computer working...\n");
          minvalue(board,iHisColor,iWhoseMove,-10000,10000,0,best);	
	  strcpy(s,best);
	  printf("Computer moving to %s\n",s);
}
	}
	if (IsValidMove(board,s,iWhoseMove))
	{
		if ((s[0]=='u') || (s[0]=='d') || (s[0]=='l') || (s[0]=='r')) {
			i_aryLastWasMove[iWhoseMove]=1;
		}
		else {
			i_aryLastWasMove[iWhoseMove]=0;
		}
		i_aryLastXLoc[iWhoseMove]=i_aryXLoc[iWhoseMove];
		i_aryLastYLoc[iWhoseMove]=i_aryYLoc[iWhoseMove];
		MakeMove(board,s,iWhoseMove);
		if (iWhoseMove==WHITE) iWhoseMove=BLACK;
		else iWhoseMove=WHITE;
		iMoveNum++;
	}
	else if (s[0]=='n')
	{
		if (iWhoseMove==WHITE) iWhoseMove=BLACK;
		else iWhoseMove=WHITE;
		iMoveNum++;
	}
	else 
	{
		printf("\nInvalid move.  Try again.\n");
	}
	i=CheckForWin();
	if (i!=EMPTY)			/* Someone won */
	{
		iGameOver=1;
	 	ShowBoard(board);
		printf("\nThe game is over!  ");
		if (i==WHITE) printf("White (O) Wins!\n");
		else if (i==BLACK) printf("Black (X) Wins!\n");
		if (!iBoth) {
			if (i==iMyColor) WittyAnswer();
		}
	}	
 } 
}


int WittyAnswer()
{
 int i;
 i=random() % 7;
 if (i==0) printf("Anybody can win, unless there happens to be a second entry.\n");
 else if (i==1) printf("He who dies with the most toys, wins.\n");
 else if (i==2) printf("It doesn't matter if you win or lose, it's how you look playing the game.\n");
 else if (i==3) printf("You were close; too bad that only counts in horseshoes and hand grenades.\n");
 else if (i==4) printf("Congratulations!  You were a runner-up!\n");
 else if (i==5) printf("Tis better to have loved and lost to have just lost.\n");
 else if (i==6) printf("Beaten by the best, now join the rest.\n");
}
