/*****************************************************************
 * Quoridor 2-player version
 * CS441/541			1/2/98
 *
 * Global defs and variables.
 *
 * Feel free to use/study any portions of this code that you
 * like for your own program.
 *
 * Kenrick Mock
 *****************************************************************/

#ifndef _globals_h
#define _globals_h

#define DEBUG 0
#define RANDOMIT 0
#define EMPTY 0
#define WHITE 1
#define BLACK 2
#define OPEN 1
#define BLOCKED 2
#define INVALID 0
#define VALID 1
#define RIGHT 2
#define BOTTOM 3
#define TRUE 1
#define FALSE 0

#define XDIM 9				/* Size of the game board */
#define YDIM 9
#define NUMFENCES 10			/* Number of fences per player */

/******************************
 Data structure for the board.
*******************************/
typedef struct cellstruct
{
 int r,b;			/* If there is a fence to the right/bottom */
 int rvalid, bvalid;		/* If its valid to put a fence to right/bottom */
 int state;			/* empty, white, or black */
 int fsource;			/* If this is where a fence originated.  For display purposes */
} cell;

/******************************
 Global variables for the
 board, how many fences
 each player has, and the
 current position of each
 players pieces
*******************************/
cell board[XDIM][YDIM];
int i_aryFences[3];
int i_aryXLoc[3];
int i_aryYLoc[3];
int i_aryLastXLoc[3];
int i_aryLastYLoc[3];
int i_aryLastWasMove[3];
int iDepth;
int iMoveNum;
int iXNeighborhood, iYNeighborhood;

#endif
